/*!
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2025 Teclib' and contributors.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */
"use strict";(self["webpackChunk_glpi_glpi"]=self["webpackChunk_glpi_glpi"]||[]).push([[11],{18:e=>{var t=[];function r(e){var r=-1;for(var n=0;n<t.length;n++){if(t[n].identifier===e){r=n;break}}return r}function n(e,n){var a={};var s=[];for(var i=0;i<e.length;i++){var l=e[i];var c=n.base?l[0]+n.base:l[0];var u=a[c]||0;var d="".concat(c," ").concat(u);a[c]=u+1;var p=r(d);var f={css:l[1],media:l[2],sourceMap:l[3],supports:l[4],layer:l[5]};if(p!==-1){t[p].references++;t[p].updater(f)}else{var m=o(f,n);n.byIndex=i;t.splice(i,0,{identifier:d,updater:m,references:1})}s.push(d)}return s}function o(e,t){var r=t.domAPI(t);r.update(e);var n=function t(n){if(n){if(n.css===e.css&&n.media===e.media&&n.sourceMap===e.sourceMap&&n.supports===e.supports&&n.layer===e.layer){return}r.update(e=n)}else{r.remove()}};return n}e.exports=function(e,o){o=o||{};e=e||[];var a=n(e,o);return function e(s){s=s||[];for(var i=0;i<a.length;i++){var l=a[i];var c=r(l);t[c].references--}var u=n(s,o);for(var d=0;d<a.length;d++){var p=a[d];var f=r(p);if(t[f].references===0){t[f].updater();t.splice(f,1)}}a=u}}},19:e=>{function t(e,t,r){var n="";if(r.supports){n+="@supports (".concat(r.supports,") {")}if(r.media){n+="@media ".concat(r.media," {")}var o=typeof r.layer!=="undefined";if(o){n+="@layer".concat(r.layer.length>0?" ".concat(r.layer):""," {")}n+=r.css;if(o){n+="}"}if(r.media){n+="}"}if(r.supports){n+="}"}var a=r.sourceMap;if(a&&typeof btoa!=="undefined"){n+="\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(a))))," */")}t.styleTagTransform(n,e,t.options)}function r(e){if(e.parentNode===null){return false}e.parentNode.removeChild(e)}function n(e){if(typeof document==="undefined"){return{update:function e(){},remove:function e(){}}}var n=e.insertStyleElement(e);return{update:function r(o){t(n,e,o)},remove:function e(){r(n)}}}e.exports=n},20:e=>{var t={};function r(e){if(typeof t[e]==="undefined"){var r=document.querySelector(e);if(window.HTMLIFrameElement&&r instanceof window.HTMLIFrameElement){try{r=r.contentDocument.head}catch(e){r=null}}t[e]=r}return t[e]}function n(e,t){var n=r(e);if(!n){throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.")}n.appendChild(t)}e.exports=n},21:(e,t,r)=>{function n(e){var t=true?r.nc:0;if(t){e.setAttribute("nonce",t)}}e.exports=n},22:e=>{function t(e){var t=document.createElement("style");e.setAttributes(t,e.attributes);e.insert(t,e.options);return t}e.exports=t},23:e=>{function t(e,t){if(t.styleSheet){t.styleSheet.cssText=e}else{while(t.firstChild){t.removeChild(t.firstChild)}t.appendChild(document.createTextNode(e))}}e.exports=t},25:e=>{e.exports=function(e){var t=e[1];var r=e[3];if(!r){return t}if(typeof btoa==="function"){var n=btoa(unescape(encodeURIComponent(JSON.stringify(r))));var o="sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(n);var a="/*# ".concat(o," */");return[t].concat([a]).join("\n")}return[t].join("\n")}},26:e=>{e.exports=function(e){var t=[];t.toString=function t(){return this.map(function(t){var r="";var n=typeof t[5]!=="undefined";if(t[4]){r+="@supports (".concat(t[4],") {")}if(t[2]){r+="@media ".concat(t[2]," {")}if(n){r+="@layer".concat(t[5].length>0?" ".concat(t[5]):""," {")}r+=e(t);if(n){r+="}"}if(t[2]){r+="}"}if(t[4]){r+="}"}return r}).join("")};t.i=function e(r,n,o,a,s){if(typeof r==="string"){r=[[null,r,undefined]]}var i={};if(o){for(var l=0;l<this.length;l++){var c=this[l][0];if(c!=null){i[c]=true}}}for(var u=0;u<r.length;u++){var d=[].concat(r[u]);if(o&&i[d[0]]){continue}if(typeof s!=="undefined"){if(typeof d[5]==="undefined"){d[5]=s}else{d[1]="@layer".concat(d[5].length>0?" ".concat(d[5]):""," {").concat(d[1],"}");d[5]=s}}if(n){if(!d[2]){d[2]=n}else{d[1]="@media ".concat(d[2]," {").concat(d[1],"}");d[2]=n}}if(a){if(!d[4]){d[4]="".concat(a)}else{d[1]="@supports (".concat(d[4],") {").concat(d[1],"}");d[4]=a}}t.push(d)}};return t}},27:(e,t)=>{Object.defineProperty(t,"__esModule",{value:true});t["default"]=(e,t)=>{const r=e.__vccOpts||e;for(const[e,n]of t){r[e]=n}return r}},96:(e,t,r)=>{r.r(t);r.d(t,{default:()=>l});var n=r(97);var o=r(99);var a=r(101);var s=r(27);const i=(0,s["default"])(o["default"],[["render",n.render],["__scopeId","data-v-b1b46442"],["__file","js/src/vue/Debug/Widget/SQLRequests.vue"]]);if(false){}const l=i},97:(e,t,r)=>{r.r(t);r.d(t,{render:()=>n.render});var n=r(98)},98:(e,t,r)=>{r.r(t);r.d(t,{render:()=>d});var n=r(9);const o={class:"overflow-auto py-2 px-3"};const a={id:"debug-sql-request-table",class:"table card-table"};const s={key:0};const i={class:"btn btn-link request-link"};const l={class:"d-flex align-items-start",style:{"max-width":"50vw"}};const c={style:{"max-width":"50vw","white-space":"break-spaces"},class:"w-100"};const u=["innerHTML"];function d(e,t,r,d,p,f){return(0,n.openBlock)(),(0,n.createElementBlock)("div",o,[(0,n.createElementVNode)("table",a,[(0,n.createElementVNode)("thead",null,[(0,n.createElementVNode)("tr",null,[d.is_global_mode?((0,n.openBlock)(),(0,n.createElementBlock)("th",{key:0,onClick:t[0]||(t[0]=e=>d.setSortedCol("request_id"))},"Request ID")):(0,n.createCommentVNode)("v-if",true),(0,n.createElementVNode)("th",{onClick:t[1]||(t[1]=e=>d.setSortedCol("num"))},"Number"),(0,n.createElementVNode)("th",{onClick:t[2]||(t[2]=e=>d.setSortedCol("query"))},"Query"),(0,n.createElementVNode)("th",{onClick:t[3]||(t[3]=e=>d.setSortedCol("time"))},"Time"),(0,n.createElementVNode)("th",{onClick:t[4]||(t[4]=e=>d.setSortedCol("rows"))},"Rows"),(0,n.createElementVNode)("th",{onClick:t[5]||(t[5]=e=>d.setSortedCol("warnings"))},"Warnings"),(0,n.createElementVNode)("th",{onClick:t[6]||(t[6]=e=>d.setSortedCol("errors"))},"Errors")])]),(0,n.createElementVNode)("tbody",null,[((0,n.openBlock)(true),(0,n.createElementBlock)(n.Fragment,null,(0,n.renderList)(d.sorted_queries_data,e=>((0,n.openBlock)(),(0,n.createElementBlock)("tr",{key:e.request_id+"-"+e.num},[d.is_global_mode?((0,n.openBlock)(),(0,n.createElementBlock)("td",s,[(0,n.createElementVNode)("button",i,(0,n.toDisplayString)(e.request_id),1)])):(0,n.createCommentVNode)("v-if",true),(0,n.createElementVNode)("td",null,(0,n.toDisplayString)(e.num),1),(0,n.createElementVNode)("td",null,[(0,n.createElementVNode)("div",l,[(0,n.createElementVNode)("div",c,[(0,n.createElementVNode)("code",{class:"d-block cm-s-default border-0",innerHTML:d.colorized_queries.get(e.request_id+"-"+e.num)},null,8,u)]),(0,n.createElementVNode)("button",{type:"button",onClick:t[7]||(t[7]=e=>d.copyToClipboard(e)),class:"ms-1 copy-code btn btn-sm btn-ghost-secondary",title:"Copy query to clipboard"},[...t[8]||(t[8]=[(0,n.createElementVNode)("i",{class:"ti ti-clipboard-copy"},null,-1)])])])]),(0,n.createElementVNode)("td",null,(0,n.toDisplayString)(e.time.toFixed(1))+" ms",1),(0,n.createElementVNode)("td",null,(0,n.toDisplayString)(e.rows),1),(0,n.createElementVNode)("td",null,(0,n.toDisplayString)(e.warnings),1),(0,n.createElementVNode)("td",null,(0,n.toDisplayString)(e.errors),1)]))),128))])])])}},99:(e,t,r)=>{r.r(t);r.d(t,{default:()=>n["default"]});var n=r(100)},100:(e,t,r)=>{r.r(t);r.d(t,{default:()=>o});var n=r(9);const o={__name:"SQLRequests",props:{initial_request:{type:Object,required:false},ajax_requests:{type:Array,required:false},current_profile:{type:Object,required:false}},setup(e,{expose:t}){t();const r=e;const o=(0,n.computed)(()=>r.current_profile===undefined&&r.ajax_requests!==undefined);function a(){const e={total_requests:0,total_duration:0,queries:{}};if(o.value){e.queries[r.initial_request.id]=r.initial_request.sql.queries;r.ajax_requests.forEach(t=>{if(t.profile&&t.profile.sql!==undefined){e.queries[t.id]=t.profile.sql.queries}})}else{e.queries[r.current_profile.id]=r.current_profile.sql.queries}$.each(e.queries,(t,r)=>{r.forEach(t=>{e.total_requests+=1;e.total_duration+=t["time"]})});return e}const s=(0,n.ref)(o.value?"request_id":"num");const i=(0,n.ref)("asc");const l=(0,n.computed)(()=>{let e=[];const t=a();$.each(t.queries,(t,r)=>{r.forEach(r=>{e.push({request_id:t,num:r["num"],time:r["time"],query:r["query"],rows:r["rows"],warnings:_.escape(r["warnings"]),errors:_.escape(r["errors"])})})});if(!o.value){e=e.filter(e=>e.request_id===r.current_profile.id)}e.sort((e,t)=>{let r=e[s.value];let n=t[s.value];if(s.value==="time"){r=parseFloat(r);n=parseFloat(n)}if(r===n){return 0}if(i.value==="asc"){return r<n?-1:1}else{return r>n?-1:1}});return e});function c(e){if(s.value===e){if(i.value==="asc"){i.value="desc"}else{i.value="asc"}}else{s.value=e;i.value="asc"}}function u(e){const t=$(e.currentTarget).parent().find("code");const r=t.text().replace(/\s+/g," ").trim();copyTextToClipboard(r);const n=$(e.currentTarget).find("i");n.removeClass("ti-clipboard-copy").addClass("ti-check");setTimeout(()=>{n.removeClass("ti-check").addClass("ti-clipboard-copy")},1e3)}function d(e){const t=["UNION","FROM","WHERE","INNER JOIN","LEFT JOIN","ORDER BY","SORT"];const r=["UNION"];e=e.replace(/\n/g," ");return Promise.resolve(window.GLPI.Monaco.colorizeText(e,"sql")).then(e=>{const n=t.map(e=>`span.mtk6:contains(${CSS.escape(e)})`).join(",");const o=r.map(e=>`span.mtk6:contains(${CSS.escape(e)})`).join(",");return $($.parseHTML(e)).find(n).before("</br>").end().find(o).after("</br>").end().html()})}const p=(0,n.reactive)(new Map);(0,n.watch)(()=>l.value,()=>{l.value.forEach(e=>{const t=e.request_id+"-"+e.num;if(!p.has(t)){p.set(t,e.query);d(e.query).then(e=>{p.set(t,e)})}})},{immediate:true,deep:true});const f={props:r,is_global_mode:o,getCombinedSQLData:a,sorted_col:s,sort_dir:i,sorted_queries_data:l,setSortedCol:c,copyToClipboard:u,cleanSQLQuery:d,colorized_queries:p,computed:n.computed,reactive:n.reactive,ref:n.ref,watch:n.watch};Object.defineProperty(f,"__isScriptSetup",{enumerable:false,value:true});return f}}},101:(e,t,r)=>{r.r(t);var n=r(102)},102:(e,t,r)=>{r.r(t);r.d(t,{default:()=>y});var n=r(18);var o=r.n(n);var a=r(19);var s=r.n(a);var i=r(20);var l=r.n(i);var c=r(21);var u=r.n(c);var d=r(22);var p=r.n(d);var f=r(23);var m=r.n(f);var v=r(103);var q={};q.styleTagTransform=m();q.setAttributes=u();q.insert=l().bind(null,"head");q.domAPI=s();q.insertStyleElement=p();var b=o()(v["default"],q);const y=v["default"]&&v["default"].locals?v["default"].locals:undefined},103:(e,t,r)=>{r.r(t);r.d(t,{default:()=>l});var n=r(25);var o=r.n(n);var a=r(26);var s=r.n(a);var i=s()(o());i.push([e.id,`\n#debug-sql-request-table thead tr th[data-v-b1b46442] {\n        cursor: pointer;\n}\n#debug-sql-request-table tbody tr td[data-v-b1b46442]:nth-of-type(3) {\n        max-width: 50vw;\n        white-space: break-spaces;\n}\n#debug-sql-request-table tbody tr td[data-v-b1b46442]:nth-of-type(4) {\n        white-space: nowrap;\n}\n#debug-sql-request-table[data-v-b1b46442] span.mtk1 {\n        color: var(--tblr-body-color);\n}\n#debug-sql-request-table code[data-v-b1b46442] {\n        color: var(--tblr-body-color);\n}\n`,"",{version:3,sources:["webpack://./js/src/vue/Debug/Widget/SQLRequests.vue"],names:[],mappings:";AAoMI;QACI,eAAe;AACnB;AACA;QACI,eAAe;QACf,yBAAyB;AAC7B;AACA;QACI,mBAAmB;AACvB;AACA;QACI,6BAA6B;AACjC;AACA;QACI,6BAA6B;AACjC",sourcesContent:["<script setup>\n    /* global copyTextToClipboard */\n    /* global _ */\n    import {computed, reactive, ref, watch} from \"vue\";\n\n    const props = defineProps({\n        initial_request: {\n            type: Object,\n            required: false\n        },\n        ajax_requests: {\n            type: Array,\n            required: false\n        },\n        current_profile: {\n            type: Object,\n            required: false\n        },\n    });\n\n    const is_global_mode = computed(() => {\n        return props.current_profile === undefined && props.ajax_requests !== undefined;\n    });\n\n    function getCombinedSQLData() {\n        const sql_data = {\n            total_requests: 0,\n            total_duration: 0,\n            queries: {}\n        };\n        if (is_global_mode.value) {\n            sql_data.queries[props.initial_request.id] = props.initial_request.sql.queries;\n            props.ajax_requests.forEach((request) => {\n                if (request.profile && request.profile.sql !== undefined) {\n                    sql_data.queries[request.id] = request.profile.sql.queries;\n                }\n            });\n        } else {\n            sql_data.queries[props.current_profile.id] = props.current_profile.sql.queries;\n        }\n        $.each(sql_data.queries, (request_id, data) => {\n            // update the total counters\n            data.forEach((query) => {\n                sql_data.total_requests += 1;\n                sql_data.total_duration += query['time'];\n            });\n        });\n\n        return sql_data;\n    }\n\n    const sorted_col = ref(is_global_mode.value ? 'request_id' : 'num');\n    const sort_dir = ref('asc');\n    const sorted_queries_data = computed(() => {\n        let sorted = [];\n\n        const sql_data = getCombinedSQLData();\n        $.each(sql_data.queries, (request_id, data) => {\n            data.forEach((query) => {\n                sorted.push({\n                    request_id: request_id,\n                    num: query['num'],\n                    time: query['time'],\n                    query: query['query'],\n                    rows: query['rows'],\n                    warnings: _.escape(query['warnings']),\n                    errors: _.escape(query['errors']),\n                });\n            });\n        });\n\n        // Filter by current profile id\n        if (!is_global_mode.value) {\n            sorted = sorted.filter((query) => {\n                return query.request_id === props.current_profile.id;\n            });\n        }\n\n        // Sort by column\n        sorted.sort((a, b) => {\n            let a_val = a[sorted_col.value];\n            let b_val = b[sorted_col.value];\n            if (sorted_col.value === 'time') {\n                a_val = parseFloat(a_val);\n                b_val = parseFloat(b_val);\n            }\n            if (a_val === b_val) {\n                return 0;\n            }\n            if (sort_dir.value === 'asc') {\n                return a_val < b_val ? -1 : 1;\n            } else {\n                return a_val > b_val ? -1 : 1;\n            }\n        });\n        return sorted;\n    });\n\n    function setSortedCol(col) {\n        if (sorted_col.value === col) {\n            if (sort_dir.value === 'asc') {\n                sort_dir.value = 'desc';\n            } else {\n                sort_dir.value = 'asc';\n            }\n        } else {\n            sorted_col.value = col;\n            sort_dir.value = 'asc';\n        }\n    }\n    function copyToClipboard(e) {\n        // copy content of code block in clipboard\n        const code =  $(e.currentTarget).parent().find('code');\n        // Normalize whitespace as spaces and trim\n        const code_clean = code.text().replace(/\\s+/g, ' ').trim();\n        copyTextToClipboard(code_clean);\n\n        // change temporary the button icon to a check then after a while return to the original icon\n        const icon = $(e.currentTarget).find('i');\n        icon.removeClass('ti-clipboard-copy').addClass('ti-check');\n        setTimeout(() => {\n            icon.removeClass('ti-check').addClass('ti-clipboard-copy');\n        }, 1000);\n    }\n\n    function cleanSQLQuery(query) {\n        const newline_keywords = ['UNION', 'FROM', 'WHERE', 'INNER JOIN', 'LEFT JOIN', 'ORDER BY', 'SORT'];\n        const post_newline_keywords = ['UNION'];\n        query = query.replace(/\\n/g, ' ');\n\n        return Promise.resolve(window.GLPI.Monaco.colorizeText(query, 'sql')).then((html) => {\n            // get all 'span' elements with mtk6 class (keywords) and insert the needed line breaks\n            const newline_before_selector = newline_keywords.map((keyword) => `span.mtk6:contains(${CSS.escape(keyword)})`).join(',');\n            const post_newline_selector = post_newline_keywords.map((keyword) => `span.mtk6:contains(${CSS.escape(keyword)})`).join(',');\n            return $($.parseHTML(html)).find(newline_before_selector).before('</br>').end().find(post_newline_selector).after('</br>').end().html();\n        });\n    }\n\n    const colorized_queries = reactive(new Map());\n\n    watch(() => sorted_queries_data.value, () => {\n        sorted_queries_data.value.forEach((query) => {\n            const key = query.request_id + '-' + query.num;\n            if (!colorized_queries.has(key)) {\n                // Show uncolored query until the colorized version is ready\n                colorized_queries.set(key, query.query);\n                cleanSQLQuery(query.query).then((html) => {\n                    colorized_queries.set(key, html);\n                });\n            }\n        });\n    }, {\n        immediate: true,\n        deep: true\n    });\n<\/script>\n\n<template>\n    <div class=\"overflow-auto py-2 px-3\">\n        <table id=\"debug-sql-request-table\" class=\"table card-table\">\n            <thead>\n                <tr>\n                    <th v-if=\"is_global_mode\" @click=\"setSortedCol('request_id')\">Request ID</th>\n                    <th @click=\"setSortedCol('num')\">Number</th>\n                    <th @click=\"setSortedCol('query')\">Query</th>\n                    <th @click=\"setSortedCol('time')\">Time</th>\n                    <th @click=\"setSortedCol('rows')\">Rows</th>\n                    <th @click=\"setSortedCol('warnings')\">Warnings</th>\n                    <th @click=\"setSortedCol('errors')\">Errors</th>\n                </tr>\n            </thead>\n            <tbody>\n                <tr v-for=\"query in sorted_queries_data\" :key=\"query.request_id + '-' + query.num\">\n                    <td v-if=\"is_global_mode\"><button class=\"btn btn-link request-link\">{{ query.request_id }}</button></td>\n                    <td>{{ query.num }}</td>\n                    <td>\n                        <div class=\"d-flex align-items-start\" style=\"max-width: 50vw;\">\n                            <div style=\"max-width: 50vw; white-space: break-spaces;\" class=\"w-100\">\n                                <code class=\"d-block cm-s-default border-0\" v-html=\"colorized_queries.get(query.request_id + '-' + query.num)\"></code>\n                            </div>\n                            <button type=\"button\" @click=\"copyToClipboard($event)\" class=\"ms-1 copy-code btn btn-sm btn-ghost-secondary\" title=\"Copy query to clipboard\">\n                                <i class=\"ti ti-clipboard-copy\"></i>\n                            </button>\n                        </div>\n                    </td>\n                    <td>{{ query.time.toFixed(1) }}&nbsp;ms</td>\n                    <td>{{ query.rows }}</td>\n                    <td>{{ query.warnings }}</td>\n                    <td>{{ query.errors }}</td>\n                </tr>\n            </tbody>\n        </table>\n    </div>\n</template>\n\n<style scoped>\n    #debug-sql-request-table thead tr th {\n        cursor: pointer;\n    }\n    #debug-sql-request-table tbody tr td:nth-of-type(3) {\n        max-width: 50vw;\n        white-space: break-spaces;\n    }\n    #debug-sql-request-table tbody tr td:nth-of-type(4) {\n        white-space: nowrap;\n    }\n    #debug-sql-request-table::v-deep(span.mtk1) {\n        color: var(--tblr-body-color);\n    }\n    #debug-sql-request-table code {\n        color: var(--tblr-body-color);\n    }\n</style>\n"],sourceRoot:""}]);const l=i}}]);